# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 368-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53656);
 script_bugtraq_id(8370);
 script_cve_id("CVE-2003-0649");
 script_version ("$");
 name = "Debian Security Advisory DSA 368-1 (xpcd)";
 script_name(name);

 desc = "The remote host is missing an update to xpcd
announced via advisory DSA 368-1.

Steve Kemp discovered a buffer overflow in xpcd-svga which can be
triggered by a long HOME environment variable.  This vulnerability
could be exploited by a local attacker to gain root privileges.

For the stable distribution (woody) this problem has been fixed in
version 2.08-8woody1.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you update your xpcd package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20368-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 368-1 (xpcd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xpcd", ver:"2.08-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpcd-gimp", ver:"2.08-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xpcd-svga", ver:"2.08-8woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
