# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 371-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53659);
 script_bugtraq_id(8231);
 script_cve_id("CVE-2003-0615");
 script_version ("$");
 name = "Debian Security Advisory DSA 371-1 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory DSA 371-1.

A cross-site scripting vulnerability exists in the start_form()
function in CGI.pm.  This function outputs user-controlled data into
the action attribute of a form element without sanitizing it, allowing
a remote user to execute arbitrary web script within the context of
the generated page.  Any program which uses this function in the
CGI.pm module may be affected.

For the current stable distribution (woody) this problem has been fixed
in version 5.6.1-8.3.

For the unstable distribution (sid) this problem has been fixed in
version 5.8.0-19.

We recommend that you update your perl package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20371-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 371-1 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.6", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.6.1-8.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
