# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 396-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53377);
 script_cve_id("CVE-2002-1562", "CVE-2003-0899");
 script_version ("$");
 name = "Debian Security Advisory DSA 396-1 (thttpd)";
 script_name(name);

 desc = "The remote host is missing an update to thttpd
announced via advisory DSA 396-1.

Several vulnerabilities have been discovered in thttpd, a tiny HTTP
server.

The Common Vulnerabilities and Exposures project identifies the
following vulnerabilities:

CVE-2002-1562: Information leak

Marcus Breiing discovered that if thttpd it is used for virtual
hosting, and an attacker supplies a specially crafted ``Host:''
header with a pathname instead of a hostname, thttpd will reveal
information about the host system.  Hence, an attacker can browse
the entire disk.

CVE-2003-0899: Arbitrary code execution

Joel Soderberg and Christer Oberg discovered a remote overflow which
allows an attacker to partially overwrite the EBP register and
hencely execute arbitrary code.

For the stable distribution (woody) these problems have been fixed in
version 2.21b-11.2.

For the unstable distribution (sid) this problem has been fixed in
version 2.23beta1-2.3.

We recommend that you upgrade your thttpd package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20396-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 396-1 (thttpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"thttpd", ver:"2.21b-11.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thttpd-util", ver:"2.21b-11.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
