# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 407-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53105);
 script_cve_id("CVE-2003-0925", "CVE-2003-0926", "CVE-2003-0927", "CVE-2003-1012", "CVE-2003-1013");
 script_version ("$");
 name = "Debian Security Advisory DSA 407-1 (ethereal)";
 script_name(name);

 desc = "The remote host is missing an update to ethereal
announced via advisory DSA 407-1.

Several vulnerabilities were discovered upstream in ethereal, a
network traffic analyzer.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2003-0925

A buffer overflow allows remote attackers to cause a denial of
service and possibly execute arbitrary code via a malformed GTP
MSISDN string.

CVE-2003-0926

Via certain malformed ISAKMP or MEGACO packets remote attackers are
able to cause a denial of service (crash).

CVE-2003-0927

A heap-based buffer overflow allows remote attackers to cause a
denial of service (crash) and possibly execute arbitrary code via
the SOCKS dissector.

CVE-2003-1012

The SMB dissector allows remote attackers to cause a denial of
service via a malformed SMB packet that triggers a segmentation
fault during processing of selected packets.

CVE-2003-1013

The Q.931 dissector allows remote attackers to cause a denial of
service (crash) via a malformed Q.931, which triggers a null
dereference.

For the stable distribution (woody) this problem has been fixed in
version 0.9.4-1woody6.

For the unstable distribution (sid) this problem has been fixed in
version 0.10.0-1.

We recommend that you upgrade your ethereal and tethereal packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20407-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 407-1 (ethereal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal", ver:"0.9.4-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.9.4-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.9.4-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.9.4-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
