# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 435-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53134);
 script_bugtraq_id(8680);
 script_cve_id("CVE-2003-0865");
 script_version ("$");
 name = "Debian Security Advisory DSA 435-1 (mpg123)";
 script_name(name);

 desc = "The remote host is missing an update to mpg123
announced via advisory DSA 435-1.

A vulnerability was discovered in mpg123, a command-line mp3 player,
whereby a response from a remote HTTP server could overflow a buffer
allocated on the heap, potentially permitting execution of arbitrary
code with the privileges of the user invoking mpg123.  In order for
this vulnerability to be exploited, mpg321 would need to request an
mp3 stream from a malicious remote server via HTTP.

For the current stable distribution (woody) this problem has been
fixed in version 0.59r-13woody2.

For the unstable distribution (sid) this problem has been fixed in
version 0.59r-15.

We recommend that you update your mpg123 package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20435-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 435-1 (mpg123)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mpg123", ver:"0.59r-13woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mpg123-esd", ver:"0.59r-13woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mpg123-nas", ver:"0.59r-13woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mpg123-oss-3dnow", ver:"0.59r-13woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mpg123-oss-i486", ver:"0.59r-13woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
