# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 500-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53189);
 script_cve_id("CVE-2004-0422");
 script_version ("$");
 name = "Debian Security Advisory DSA 500-1 (flim)";
 script_name(name);

 desc = "The remote host is missing an update to flim
announced via advisory DSA 500-1.

Tatsuya Kinoshita discovered a vulnerability in flim, an emacs library
for working with internet messages, where temporary files were created
without taking appropriate precautions.  This vulnerability could
potentially be exploited by a local user to overwrite files with the
privileges of the user running emacs.  the 'chroot' option.

For the current stable distribution (woody) this problem has been
fixed in version 1.14.3-9woody1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your flim package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20500-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 500-1 (flim)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"flim", ver:"1.14.3-9woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
