# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 514-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53205);
 script_bugtraq_id(9686);
 script_cve_id("CVE-2004-0077");
 script_version ("$");
 name = "Debian Security Advisory DSA 514-1 (kernel-source-2.2.20, kernel-image-2.2-sparc)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-source-2.2.20, kernel-image-2.2-sparc
announced via advisory DSA 514-1.

Paul Starzetz and Wojciech Purczynski of isec.pl discovered a critical
security vulnerability in the memory management code of Linux inside
the mremap(2) system call.  Due to flushing the TLB (Translation
Lookaside Buffer, an address cache) too early it is possible for an
attacker to trigger a local root exploit.

The attack vectors for 2.4.x and 2.2.x kernels are exclusive for the
respective kernel series, though.  We formerly believed that the
exploitable vulnerability in 2.4.x does not exist in 2.2.x which is
still true.  However, it turned out that a second (sort of)
vulnerability is indeed exploitable in 2.2.x, but not in 2.4.x, with a
different exploit, of course.

For the stable distribution (woody) these problems have been fixed in
version 9woody1 of Linux 2.2 kernel images for the sparc architecture
and in version 2.2.20-5woody3 of Linux 2.2.20 source.

For the unstable distribution (sid) these problems have been fixed in
version 9.1 of Linux 2.2 kernel images for the sparc architecture.

This problem has been fixed for other architectures already.

We recommend that you upgrade your Linux kernel package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20514-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 514-1 (kernel-source-2.2.20, kernel-image-2.2-sparc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-doc-2.2.20", ver:"2.2.20-5woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.2.20", ver:"2.2.20-5woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.2.20-sparc", ver:"9woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.2.20-sun4cdm", ver:"9woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.2.20-sun4dm-smp", ver:"9woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.2.20-sun4u", ver:"9woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.2.20-sun4u-smp", ver:"9woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
