# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 521-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53213);
 script_bugtraq_id(10571);
 script_cve_id("CVE-2004-0451");
 script_version ("$");
 name = "Debian Security Advisory DSA 521-1 (sup)";
 script_name(name);

 desc = "The remote host is missing an update to sup
announced via advisory DSA 521-1.

jaguar@felinemenace.org discovered a format string vulnerability in
sup, a set of programs to synchronize collections of files across a
number of machines, whereby a remote attacker could potentially cause
arbitrary code to be executed with the privileges of the supfilesrv
process (this process does not run automatically by default).

CVE-2004-0451: format string vulnerabilities in sup via syslog(3) in
logquit, logerr, loginfo functions

For the current stable distribution (woody), this problem has been
fixed in version 1.8-8woody2.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your sup package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20521-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 521-1 (sup)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sup", ver:"1.8-8woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
