# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 528-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53219);
 script_cve_id("CVE-2004-0635");
 script_version ("$");
 name = "Debian Security Advisory DSA 528-1 (ethereal)";
 script_name(name);

 desc = "The remote host is missing an update to ethereal
announced via advisory DSA 528-1.

Several denial of service vulnerabilities were discovered in ethereal,
a network traffic analyzer.  These vulnerabilites are described in the
ethereal advisory enpa-sa-00015.  Of these, only one (CVE-2004-0635)
affects the version of ethereal in Debian woody.  This vulnerability
could be exploited by a remote attacker to crash ethereal with an
invalid SNMP packet.

For the current stable distribution (woody), these problems have been
fixed in version 0.9.4-1woody8.

For the unstable distribution (sid), these problems have been fixed in
version 0.10.5-1.

We recommend that you update your ethereal package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20528-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 528-1 (ethereal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal", ver:"0.9.4-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.9.4-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.9.4-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.9.4-1woody8", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
