# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 556-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53260);
 script_cve_id("CVE-2004-0911");
 script_version ("$");
 name = "Debian Security Advisory DSA 556-2 (netkit-telnet)";
 script_name(name);

 desc = "The remote host is missing an update to netkit-telnet
announced via advisory DSA 556-2.

This is an update for DSA 556-1 which was intended to fix a denial of
service situation in netkit-telnet but didn't.  The update for
unstable did fix the problem.  For completeness below is the original
advisory text:

Michal Zalewski discovered a bug in the netkit-telnet server (telnetd)
whereby a remote attacker could cause the telnetd process to free an
invalid pointer.  This causes the telnet server process to crash,
leading to a straightforward denial of service (inetd will disable the
service if telnetd is crashed repeatedly), or possibly the execution
of arbitrary code with the privileges of the telnetd process (by
default, the 'telnetd' user).

For the unstable distribution (sid) this problem has been fixed in
version 0.17-26.

For the stable distribution (woody) this problem has been fixed in
version 0.17-18woody2.

We recommend that you upgrade your netkit-telnet-ssl package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20556-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 556-2 (netkit-telnet)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"telnet", ver:"0.17-18woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"telnetd", ver:"0.17-18woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
