# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 587-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53278);
 script_bugtraq_id(11248);
 script_cve_id("CVE-2004-0964");
 script_version ("$");
 name = "Debian Security Advisory DSA 587-1 (freeamp)";
 script_name(name);

 desc = "The remote host is missing an update to freeamp
announced via advisory DSA 587-1.

Luigi Auriemma discovered a buffer overflow condition in the playlist
module of freeamp which could lead to arbitrary code execution.
Recent versions of freeamp were renamed into zinf.

For the stable distribution (woody) this problem has been fixed in
version 2.1.1.0-4woody2.

For the unstable distribution (sid) this problem does not exist in the
zinf packageas the code in question was rewritten.

We recommend that you upgrade your freeamp packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20587-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 587-1 (freeamp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freeamp-doc", ver:"2.1.1.0-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeamp", ver:"2.1.1.0-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeamp-extras", ver:"2.1.1.0-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreeamp-alsa", ver:"2.1.1.0-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreeamp-esound", ver:"2.1.1.0-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
