# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 638-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53473);
 script_cve_id("CVE-2004-0560", "CVE-2004-0561");
 script_version ("$");
 name = "Debian Security Advisory DSA 638-1 (gopher)";
 script_name(name);

 desc = "The remote host is missing an update to gopher
announced via advisory DSA 638-1.

jaguar has discovered two security relevant problems in gopherd, the
Gopher server in Debian which is part of the gopher package.  The
Common Vulnerabilities and Exposures project identifies the following
vulnerabilities:

CVE-2004-0560

An integer overflow can happen when posting content of a specially
calculated size.

CVE-2004-0561

A format string vulnerability has been found in the log routine.

For the stable distribution (woody) these problems have been fixed in
version 3.0.3woody2.

The unstable distribution (sid) does not contain a gopherd package.
It has been replaced by Pygopherd.

We recommend that you upgrade your gopherd package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20638-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 638-1 (gopher)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gopher", ver:"3.0.3woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gopherd", ver:"3.0.3woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
