# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 661-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53539);
 script_bugtraq_id(12380);
 script_cve_id("CVE-2005-0017");
 script_version ("$");
 name = "Debian Security Advisory DSA 661-2 (f2c)";
 script_name(name);

 desc = "The remote host is missing an update to f2c
announced via advisory DSA 661-2.

Dan McMahill noticed that our our advisory DSA 661-1 did not correct
the multiple insecure files problem, hence, this update.  For
completeness below is the original advisory text:

Javier Fernndez-Sanguino Pea from the Debian Security Audit project
discovered that f2c and fc, which are both part of the f2c package, a
fortran 77 to C/C++ translator, open temporary files insecurely and
are hence vulnerable to a symlink attack.  The Common
Vulnerabilities and Exposures project identifies the following
vulnerabilities:

CVE-2005-0017

Multiple insecure temporary files in the f2c translator.

For the stable distribution (woody) and all others including testing
this problem has been fixed in version 20010821-3.2.

We recommend that you upgrade your f2c package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20661-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 661-2 (f2c)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"f2c", ver:"20010821-3.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
