# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 669-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53498);
 script_cve_id("CVE-2004-0594", "CVE-2004-0595");
 script_version ("$");
 name = "Debian Security Advisory DSA 669-1 (php3)";
 script_name(name);

 desc = "The remote host is missing an update to php3
announced via advisory DSA 669-1.

Two vulnerabilities have been discovered in php4 which also apply to
the version of php3 in the stable Debian distribution.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2004-0594

The memory_limit functionality allows remote attackers to execute
arbitrary code under certain circumstances.

CVE-2004-0595

The strip_tags function does not filter null (\0) characters
within tag names when restricting input to allowed tags, which
allows dangerous tags to be processed by some web browsers which
could lead to cross-site scripting (XSS) vulnerabilities.

For the stable distribution (woody) these problems have been fixed in
version 3.0.18-23.1woody2.

For the unstable distribution (sid) these problems have been fixed in
version 3.0.18-27.

We recommend that you upgrade your php3 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20669-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 669-1 (php3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php3-doc", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-gd", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-imap", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-ldap", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-magick", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-mhash", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-mysql", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-snmp", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-xml", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-dev", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-gd", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-imap", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-ldap", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-magick", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-mhash", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-mysql", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-snmp", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-xml", ver:"3.0.18-23.1woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
