# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 674-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53502);
 script_cve_id("CVE-2004-1177", "CVE-2005-0202");
 script_version ("$");
 name = "Debian Security Advisory DSA 674-1 (mailman)";
 script_name(name);

 desc = "The remote host is missing an update to mailman
announced via advisory DSA 674-1.

Two security related problems have been discovered in mailman,
web-based GNU mailing list manager.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2004-1177

Florian Weimer discovered a cross-site scripting vulnerability in
mailman's automatically generated error messages.  An attacker
could craft an URL containing JavaScript (or other content
embedded into HTML) which triggered a mailman error page that
would include the malicious code verbatim.

CVE-2005-0202

Several listmasters have noticed unauthorised access to archives
of private lists and the list configuration itself, including the
users passwords.  Administrators are advised to check the
webserver logfiles for requests that contain /...../ and the
path to the archives or cofiguration.  This does only seem to
affect installations running on web servers that do not strip
slashes, such as Apache 1.3.

For the stable distribution (woody) these problems have been fixed in
version 2.0.11-1woody9.

For the unstable distribution (sid) these problems have been fixed in
version 2.1.5-6.

We recommend that you upgrade your mailman package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20674-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 674-1 (mailman)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mailman", ver:"2.0.11-1woody9", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
