# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 691-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53521);
 script_cve_id("CVE-2005-0098", "CVE-2005-0099");
 script_version ("$");
 name = "Debian Security Advisory DSA 691-1 (abuse)";
 script_name(name);

 desc = "The remote host is missing an update to abuse
announced via advisory DSA 691-1.

Several vulnerabilities have been discovered in abuse, the SDL port of
the Abuse action game.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2005-0098

Erik Sjlund discovered several buffer overflows in the command line
handling, which could lead to the execution of arbitrary code with
elevated privileges since it is installed setuid root.

CVE-2005-0099

Steve Kemp discoverd that that abuse creates some files without
dropping privileges first, which may lead to the creation and
overwriting of arbitrary files.

For the stable distribution (woody) these problems have been fixed in
version 2.00+-3woody4.

The unstable distribution (sid) does not contain an abuse package anymore.

We recommend that you upgrade your abuse package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20691-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 691-1 (abuse)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"abuse", ver:"2.00+-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
