# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 708-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53535);
 script_cve_id("CVE-2005-0525");
 script_version ("$");
 name = "Debian Security Advisory DSA 708-1 (php3)";
 script_name(name);

 desc = "The remote host is missing an update to php3
announced via advisory DSA 708-1.

An iDEFENSE researcher discovered two problems in the image processing
functions of PHP, a server-side, HTML-embedded scripting language, of
which one is present in PHP3 as well.  When reading a JPEG image, PHP
can be tricked into an endless loop due to insufficient input
validation.

For the stable distribution (woody) this problem has been fixed in
version 3.0.18-23.1woody3.

For the unstable distribution (sid) this problem has been fixed in
version 3.0.18-31.

We recommend that you upgrade your php3 package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20708-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 708-1 (php3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php3-doc", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-gd", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-imap", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-ldap", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-magick", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-mhash", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-mysql", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-snmp", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-xml", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-dev", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-gd", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-imap", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-ldap", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-magick", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-mhash", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-mysql", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-snmp", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-xml", ver:"3.0.18-23.1woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
