# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 847-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55562);
 script_cve_id("CVE-2005-2966");
 script_bugtraq_id(15000);
 script_version ("$");
 name = "Debian Security Advisory DSA 847-1 (dia)";
 script_name(name);

 desc = "The remote host is missing an update to dia
announced via advisory DSA 847-1.

Joxean Koret discovered that the Python SVG import plugin in dia, a
vector-oriented diagram editor, does not properly sanitise data read
from an SVG file and is hence vulnerable to execute arbitrary Python
code.

The old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 0.94.0-7sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 0.94.0-15.

We recommend that you upgrade your dia package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20847-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 847-1 (dia)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dia-common", ver:"0.94.0-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dia", ver:"0.94.0-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dia-gnome", ver:"0.94.0-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dia-libs", ver:"0.94.0-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
