# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 848-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55561);
 script_cve_id("CVE-2005-2662", "CVE-2005-2663");
 script_version ("$");
 name = "Debian Security Advisory DSA 848-1 (masqmail)";
 script_name(name);

 desc = "The remote host is missing an update to masqmail
announced via advisory DSA 848-1.

Jens Steube discovered two vulnerabilities in masqmail, a mailer for
hosts without permanent internet connection.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2005-2662
When sending failed mail messages, the address is not sanitised,
which allows a local attacker to execute arbitrary commands as the
mail user.

CVE-2005-2663
When opening the log file, masqmail does not relinquish
privileges, which allows a local attacker to overwrite arbitrary
files via a symlink attack.

For the old stable distribution (woody) these problems have been fixed in
version 0.1.16-2.2.

For the stable distribution (sarge) these problems have been fixed in
version 0.2.20-1sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 0.2.20-1sarge1.

We recommend that you upgrade your masqmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20848-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 848-1 (masqmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"masqmail", ver:"0.1.16-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"masqmail", ver:"0.2.20-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
