# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 855-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55598);
 script_bugtraq_id(14999);
 script_cve_id("CVE-2005-3150");
 script_version ("$");
 name = "Debian Security Advisory DSA 855-1 (weex)";
 script_name(name);

 desc = "The remote host is missing an update to weex
announced via advisory DSA 855-1.

Ulf Hrnhammar from the Debian Security Audit Project discovered a
format string vulnerability in weex, a non-interactive FTP client for
updating web pages, that could be exploited to execute arbitrary code
on the clients machine.

For the old stable distribution (woody) this problem has been fixed in
version 2.6.1-4woody2.

For the stable distribution (sarge) this problem has been fixed in
version 2.6.1-6sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.6.1-6sarge1.

We recommend that you upgrade your weex package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20855-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 855-1 (weex)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"weex", ver:"2.6.1-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"weex", ver:"2.6.1-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
