# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 908-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55911);
 script_bugtraq_id(15363);
 script_cve_id("CVE-2005-3354");
 script_version ("$");
 name = "Debian Security Advisory DSA 908-1 (sylpheed-claws)";
 script_name(name);

 desc = "The remote host is missing an update to sylpheed-claws
announced via advisory DSA 908-1.

Colin Leroy discovered several buffer overflows in a number of
importer routines in sylpheed-claws, an extended version of the
Sylpheed mail client, that could lead to the execution of arbitrary
code.

The following matrix explains which versions fix this vulnerability

                     old stable (woody)   stable (sarge)  unstable (sid)
sylpheed               0.7.4-4woody1      1.0.4-1sarge1      2.0.4-1
sylpheed-gtk1              n/a                 n/a           1.0.6-1
sylpheed-claws       0.7.4claws-3woody1   1.0.4-1sarge1      1.0.5-2
sylpheed-claws-gtk2        n/a                 n/a          1.9.100-1

We recommend that you upgrade your sylpheed-claws package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20908-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 908-1 (sylpheed-claws)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sylpheed-claws", ver:"0.7.4claws-3woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-i18n", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-plugins", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-scripts", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsylpheed-claws-dev", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-clamav", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-dillo-viewer", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-image-viewer", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-pgpmime", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-spamassassin", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sylpheed-claws-trayicon", ver:"1.0.4-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
