# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 938-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56141);
 script_cve_id("CVE-2005-3191", "CVE-2005-3193", "CVE-2005-3624", "CVE-2005-3625", "CVE-2005-3626", "CVE-2005-3627", "CVE-2005-3628");
 script_version ("$");
 name = "Debian Security Advisory DSA 938-1 (koffice)";
 script_name(name);

 desc = "The remote host is missing an update to koffice
announced via advisory DSA 938-1.

infamous41md and chris Evans discovered several heap based buffer
overflows in xpdf, the Portable Document Format (PDF) suite, which is
also present in koffice, the KDE Office Suite, and which can lead to a
denial of service by crashing the application or possibly to the
execution of arbitrary code.

The old stable distribution (woody) does not contain koffice packages.

For the stable distribution (sarge) these problems have been fixed in
version 1.3.5-4.sarge.2.

For the unstable distribution (sid) these problems have been fixed in
version 1.4.2-6.

We recommend that you upgrade your koffice package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20938-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 938-1 (koffice)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kivio-data", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-data", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"karbon", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kchart", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kformula", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kivio", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-dev", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koffice-libs", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"koshell", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kpresenter", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kspread", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kugar", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kword", ver:"1.3.5-4.sarge.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
