# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 944-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56188);
 script_cve_id("CVE-2005-4238", "CVE-2005-4518", "CVE-2005-4519", "CVE-2005-4520", "CVE-2005-4521", "CVE-2005-4522", "CVE-2005-4523", "CVE-2005-4524");
 script_bugtraq_id(15842,16046);
 script_version ("$");
 name = "Debian Security Advisory DSA 944-1 (mantis)";
 script_name(name);

 desc = "The remote host is missing an update to mantis
announced via advisory DSA 944-1.

Several security related problems have been discovered in Mantis, a
web-based bug tracking system. For details on the issues resolved,
please visit the referenced advisories.

The old stable distribution (woody) does not seem to be affected by
these problems.

For the stable distribution (sarge) these problems have been fixed in
version 0.19.2-5sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 0.19.4-1.

We recommend that you upgrade your mantis package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20944-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 944-1 (mantis)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mantis", ver:"0.19.2-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
