# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 965-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56243);
 script_cve_id("CVE-2005-3732");
 script_bugtraq_id(15523);
 script_version ("$");
 name = "Debian Security Advisory DSA 965-1 (ipsec-tools)";
 script_name(name);

 desc = "The remote host is missing an update to ipsec-tools
announced via advisory DSA 965-1.

The Internet Key Exchange version 1 (IKEv1) implementation in racoon
from ipsec-tools, IPsec tools for Linux, try to dereference a NULL
pointer under certain conditions which allows a remote attacker to
cause a denial of service.

The old stable distribution (woody) does not contain ipsec-tools.

For the stable distribution (sarge) this problem has been fixed in
version 0.5.2-1sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 0.6.3-1.

We recommend that you upgrade your racoon package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20965-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 965-1 (ipsec-tools)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.5.2-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"racoon", ver:"0.5.2-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
