# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 985-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56358);
 script_cve_id("CVE-2006-0645");
 script_bugtraq_id(16568);
 script_version ("$");
 name = "Debian Security Advisory DSA 985-1 (libtasn1-2)";
 script_name(name);

 desc = "The remote host is missing an update to libtasn1-2
announced via advisory DSA 985-1.

Evgeny Legerov discovered several out-of-bounds memory accesses in the
DER decoding component component of the Tiny ASN.1 Library that allows
attackers to crash the DER decoder and possibly execute arbitrary code.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 2_0.2.10-3sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your gnutls packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20985-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 985-1 (libtasn1-2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtasn1-2", ver:"0.2.10-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtasn1-2-dev", ver:"0.2.10-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
