# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0325 (openssl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63141);
 script_cve_id("CVE-2008-5077", "CVE-2008-0891", "CVE-2008-1672");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-0325 (openssl)";
 script_name(name);

 desc = "The remote host is missing an update to openssl
announced via advisory FEDORA-2009-0325.

Update Information:

Only one important security fix and two very simple bugfixes.

ChangeLog:

* Wed Jan  7 2009 Tomas Mraz  0.9.8g-9.12
- fix CVE-2008-5077 - incorrect checks for malformed signatures (#476671)
- add -no_ign_eof option (#462393)
- do not add tls extensions to server hello for SSLv3 either

References:

[ 1 ] Bug #476671 - CVE-2008-5077 OpenSSL Incorrect checks for malformed signatures
https://bugzilla.redhat.com/show_bug.cgi?id=476671

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update openssl' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0325

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0325 (openssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8g~9.12.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8g~9.12.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-devel", rpm:"openssl-devel~0.9.8g~9.12.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-perl", rpm:"openssl-perl~0.9.8g~9.12.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-debuginfo", rpm:"openssl-debuginfo~0.9.8g~9.12.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
