# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0542 (xine-lib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63213);
 script_cve_id("CVE-2008-5234", "CVE-2008-5236", "CVE-2008-5237", "CVE-2008-5239", "CVE-2008-5240", "CVE-2008-5243", "CVE-2008-3231");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-0542 (xine-lib)";
 script_name(name);

 desc = "The remote host is missing an update to xine-lib
announced via advisory FEDORA-2009-0542.

Update Information:

This updates xine-lib to the upstream 1.1.16 release.
This fixes several bugs, including the security issues
CVE-2008-5234 vector 1, CVE-2008-5236, CVE-2008-5237,
CVE-2008-5239, CVE-2008-5240 vectors 3 & 4 and CVE-2008-5243.  See
http://sourceforge.net/project/shownotes.php?release_id=652075&group_id=9655
for the full list of changes.

In addition, the Fedora xine-lib package now
includes the demuxers for the MPEG container format,
which are not patent-encumbered. (The decoders for actual
MPEG video and audio data are still excluded due to
software patents.)

ChangeLog:

* Wed Jan  7 2009 Kevin Kofler  - 1.1.16-1.1
- patch for old libcaca in F9-
* Wed Jan  7 2009 Rex Dieter  - 1.1.16-1
- xine-lib-1.1.16, plugin ABI 1.25
- --with-external-libdvdnav, include mpeg demuxers (#213597)

References:

[ 1 ] Bug #213597 - xine-lib: include MPEG demuxers
https://bugzilla.redhat.com/show_bug.cgi?id=213597

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xine-lib' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0542

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0542 (xine-lib)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.16~1.fc9.1", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-devel", rpm:"xine-lib-devel~1.1.16~1.fc9.1", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-extras", rpm:"xine-lib-extras~1.1.16~1.fc9.1", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-pulseaudio", rpm:"xine-lib-pulseaudio~1.1.16~1.fc9.1", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-debuginfo", rpm:"xine-lib-debuginfo~1.1.16~1.fc9.1", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
