# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10165 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64999);
 script_cve_id("CVE-2009-2903", "CVE-2009-3290", "CVE-2009-2847", "CVE-2009-2692", "CVE-2009-2406", "CVE-2009-2407", "CVE-2009-1895", "CVE-2009-1897", "CVE-2009-0065", "CVE-2008-5079", "CVE-2009-3001", "CVE-2009-3002");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-10165 (kernel)");

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-10165.

Update Information:

Update to kernel 2.6.27.35:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.31
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.32
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.33
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.34
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.35

ChangeLog:

* Sat Sep 26 2009 Chuck Ebbert   2.6.27.35-170.2.94
- Backport appletalk: Fix skb leak when ipddp interface is not loaded
(fixes CVE-2009-2903)
* Sat Sep 26 2009 Chuck Ebbert   2.6.27.35-170.2.93
- Backport KVM: x86: Disallow hypercalls for guest callers in rings > 0
(fixes CVE-2009-3290)
* Thu Sep 24 2009 Chuck Ebbert   2.6.27.35-170.2.92
- Linux 2.6.27.35
- Drop merged patches:
linux-2.6-nfsd-report-short-writes-fix.patch
linux-2.6-nfsd-report-short-writes.patch
* Tue Sep 15 2009 Chuck Ebbert   2.6.27.34-170.2.91
- Linux 2.6.27.34
- Drop merged patch: linux-2.6-slub-fix-destroy-by-rcu.patch
* Wed Sep  9 2009 Chuck Ebbert   2.6.27.32-170.2.90
- 2.6.27.32 final
- Drop linux-2.6-ocfs2-handle-len-0.patch, added after .32-rc1
* Mon Sep  7 2009 Chuck Ebbert   2.6.27.32-170.2.89.rc1
- Backport fix for b43 on ppc64 to 2.6.27 (#514787)
* Sun Sep  6 2009 Chuck Ebbert   2.6.27.32-170.2.88.rc1
- Add patches requested for the next stable release:
linux-2.6-slub-fix-destroy-by-rcu.patch (fixes bug in 2.6.27.29)
linux-2.6-ocfs2-handle-len-0.patch (fixes bug in 2.6.27.32-rc1)
* Fri Sep  4 2009 Chuck Ebbert   2.6.27.32-170.2.87.rc1
- Copy fix for NFS short write reporting from F-10 2.6.29 kernel (#493500)

References:

[ 1 ] Bug #515392 - CVE-2009-2847 kernel: information leak in sigaltstack
https://bugzilla.redhat.com/show_bug.cgi?id=515392
[ 2 ] Bug #524124 - CVE-2009-3290 kernel: KVM: x86: Disallow hypercalls for guest callers in rings > 0
https://bugzilla.redhat.com/show_bug.cgi?id=524124
[ 3 ] Bug #522331 - CVE-2009-2903 kernel: appletalk: denial of service when handling IP tunnelled over DDP datagrams
https://bugzilla.redhat.com/show_bug.cgi?id=522331
[ 4 ] Bug #519305 - CVE-2009-3001, CVE-2009-3002 kernel: numerous getname() infoleaks
https://bugzilla.redhat.com/show_bug.cgi?id=519305

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10165

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10165 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.35~170.2.94.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
