# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10233 (deltarpm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65744);
 script_cve_id("CAN-2005-1849");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-10233 (deltarpm)");

 desc = "The remote host is missing an update to deltarpm
announced via advisory FEDORA-2009-10233.

Update Information:

deltarpm prior to the current build ships with a bundled copy of zlib.  This
version of zlib has a known vulnerability with CVE identifier: CAN-2005-1849
This build of deltarpm patches the program to use the system zlib (which was
fixed when the vulnerability was first discovered) instead of the bundled copy.

ChangeLog:

* Wed Sep 30 2009 Toshio Kuratomi  - 3.4-11.1
- Build against the system zlib, not the bundled library.  This remedies the
fact that the included zlib is affected by CAN-2005-1849.
- Fix cfile_detect_rsync() to detect rsync even if we don't have a zlib capable
of making rsync-friendly compressed files.

References:

[ 1 ] Bug #526432 - deltarpm contains an own, modified copy of zlib
https://bugzilla.redhat.com/show_bug.cgi?id=526432

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update deltarpm' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10233

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10233 (deltarpm)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"deltarpm", rpm:"deltarpm~3.4~11.fc10.1", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"deltarpm-debuginfo", rpm:"deltarpm-debuginfo~3.4~11.fc10.1", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
