# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10730 (texlive)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66260);
 script_cve_id("CVE-2009-1284");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-10730 (texlive)");

 desc = "The remote host is missing an update to texlive
announced via advisory FEDORA-2009-10730.

ChangeLog:

* Fri Oct 23 2009 Jindrich Novy  2007-46
- add missing dependency on kpathsea
* Thu Oct 15 2009 Jindrich Novy  2007-45
- make kpathsea not dependent on texlive
- fix lacheck again (#451513)
- fix dvips configuration (#467542)
- update kpathsea description and summary (#519257)
- use upstream patch to fix pool overflow CVE-2009-1284 (#492136)
- don't complain if the pdvipsk hunks touching config.ps don't apply
- avoid clashes with getline() from glibc
- texlive-east-asian now requires texlive-texmf-east-asian (#487258)
- do not attempt to remove old fonts via cron in /var/lib/texmf,
fonts are stored in ~/.texlive2007/texmf-var per-user
(#477833, #463975, #453468)
- use correct paths in brp-* post install scriptlets (#468179)
- fix build with gcc4.4

References:

[ 1 ] Bug #492136 - CVE-2009-1284 tetex, texlive: bibtex's invalid reads/writes when parsing big *.bib file
https://bugzilla.redhat.com/show_bug.cgi?id=492136

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update texlive' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10730

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10730 (texlive)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kpathsea", rpm:"kpathsea~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kpathsea-devel", rpm:"kpathsea-devel~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mendexk", rpm:"mendexk~2.6e~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive", rpm:"texlive~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-afm", rpm:"texlive-afm~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-context", rpm:"texlive-context~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-doc", rpm:"texlive-doc~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-dvips", rpm:"texlive-dvips~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-dviutils", rpm:"texlive-dviutils~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-east-asian", rpm:"texlive-east-asian~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-latex", rpm:"texlive-latex~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-utils", rpm:"texlive-utils~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-xetex", rpm:"texlive-xetex~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"texlive-debuginfo", rpm:"texlive-debuginfo~2007~46.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
