# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10823 (poppler)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66139);
 script_cve_id("CVE-2009-3603", "CVE-2009-3604", "CVE-2009-3606", "CVE-2009-3607", "CVE-2009-3608", "CVE-2009-3609");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-10823 (poppler)");

 desc = "The remote host is missing an update to poppler
announced via advisory FEDORA-2009-10823.

Update Information:

This build addresses several recent security issues.

ChangeLog:

* Sun Oct 25 2009 Rex Dieter  - 0.8.8-7
- CVE-2009-3603 SplashBitmap::SplashBitmap integer overflow (#526915)
- CVE-2009-3604 Splash::drawImage integer overflow and missing allocation
                return value check(#526911)
- CVE-2009-3606 PSOutputDev::doImageL1Sep integer overflow (#526877)
- CVE-2009-3607 create_surface_from_thumbnail_data integer overflow (#526924)
- CVE-2009-3608 integer overflow in ObjectStream::ObjectStream (#526637)
- CVE-2009-3609 ImageStream::ImageStream integer overflow (#526893)

References:

[ 1 ] Bug #526915 - CVE-2009-3603 xpdf/poppler: SplashBitmap::SplashBitmap integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=526915
[ 2 ] Bug #526911 - CVE-2009-3604 xpdf/poppler: Splash::drawImage integer overflow and missing allocation return value check
https://bugzilla.redhat.com/show_bug.cgi?id=526911
[ 3 ] Bug #526877 - CVE-2009-3606 xpdf/poppler: PSOutputDev::doImageL1Sep integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=526877
[ 4 ] Bug #526924 - CVE-2009-3607 poppler: create_surface_from_thumbnail_data integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=526924
[ 5 ] Bug #526637 - CVE-2009-3608 xpdf/poppler: integer overflow in ObjectStream::ObjectStream (oCERT-2009-016)
https://bugzilla.redhat.com/show_bug.cgi?id=526637
[ 6 ] Bug #526893 - CVE-2009-3609 xpdf/poppler: ImageStream::ImageStream integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=526893

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update poppler' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10823

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10823 (poppler)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-glib-devel", rpm:"poppler-glib-devel~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt-devel", rpm:"poppler-qt-devel~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt4", rpm:"poppler-qt4~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt4-devel", rpm:"poppler-qt4-devel~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-utils", rpm:"poppler-utils~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-debuginfo", rpm:"poppler-debuginfo~0.8.7~7.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
