# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11649 (proftpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66290);
 script_cve_id("CVE-2009-3639");
 script_version ("$Revision$");
 script_name("Fedora Core 11 FEDORA-2009-11649 (proftpd)");

 desc = "The remote host is missing an update to proftpd
announced via advisory FEDORA-2009-11649.

Update Information:

This update fixes CVE-2009-3639, in which proftpd's mod_tls, when the
dNSNameRequired TLS option is enabled, does not properly handle a '\0' character
in a domain name in the Subject Alternative Name field of an X.509 client
certificate. This allows remote attackers to bypass intended client-hostname
restrictions via a crafted certificate issued by a legitimate Certification
Authority.

ChangeLog:

* Wed Oct 21 2009 Paul Howarth  1.3.2b-1
- Update to 1.3.2b
- Fixed regression causing command-line define options not to work (bug 3221)
- Fixed SSL/TLS cert subjectAltName verification (bug 3275, CVE-2009-3639)
- Use correct cached user values with SQLNegativeCache on (bug 3282)
- Fix slower transfers of multiple small files (bug 3284)
- Support MaxTransfersPerHost, MaxTransfersPerUser properly (bug 3287)
- Handle symlinks to directories with trailing slashes properly (bug 3297)
- Drop upstreamed defines patch (bug 3221)

References:

[ 1 ] Bug #530719 - CVE-2009-3639 ProFTPD: Doesn't properly handle NULL character in subjectAltName
https://bugzilla.redhat.com/show_bug.cgi?id=530719

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update proftpd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11649

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-11649 (proftpd)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"proftpd", rpm:"proftpd~1.3.2b~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-ldap", rpm:"proftpd-ldap~1.3.2b~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-mysql", rpm:"proftpd-mysql~1.3.2b~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-postgresql", rpm:"proftpd-postgresql~1.3.2b~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-debuginfo", rpm:"proftpd-debuginfo~1.3.2b~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
