# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12439 (php-pear-Mail)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66431);
 script_cve_id("CVE-2009-4023", "CVE-2009-4111");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-12439 (php-pear-Mail)");

 desc = "The remote host is missing an update to php-pear-Mail
announced via advisory FEDORA-2009-12439.

Update Information:

Fix CVE-2009-4023, CVE-2009-4111    PEAR's Mail class did not properly escape
content of mail header fields, when using the sendmail backend. A remote
attacker could send an email message, with specially-crafted headers to local
user, leading to disclosure of content and potentially, to modification of
arbitrary system file, once the email message was processed by the PEAR's Mail
class.

ChangeLog:

* Fri Nov 27 2009 Remi Collet  1.1.14-5
- Fix CVE-2009-4023 (#540842)
- rename Mail.xml to php-pear-Mail.xml
* Sun Jul 26 2009 Fedora Release Engineering  - 1.1.14-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild
* Thu Feb 26 2009 Fedora Release Engineering  - 1.1.14-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

References:

[ 1 ] Bug #540842 - CVE-2009-4023 php-pear-Mail: Absent sanitization of mail header fields
https://bugzilla.redhat.com/show_bug.cgi?id=540842

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update php-pear-Mail' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12439

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-12439 (php-pear-Mail)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"php-pear-Mail", rpm:"php-pear-Mail~1.1.14~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
