# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12517 (asterisk)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66576);
 script_cve_id("CVE-2009-4055");
 script_version ("$Revision$");
 script_name("Fedora Core 12 FEDORA-2009-12517 (asterisk)");

 desc = "The remote host is missing an update to asterisk
announced via advisory FEDORA-2009-12517.

Update Information:

Update to 1.6.1.11 to fix AST-2009-010/CVE-2009-4055
http://downloads.asterisk.org/pub/security/AST-2009-010.html

ChangeLog:

* Mon Nov 30 2009 Jeffrey C. Ollie  - 1.6.1.11-1
- Update to 1.6.1.11 to fix AST-2009-010/CVE-2009-4055

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update asterisk' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12517

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-12517 (asterisk)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"asterisk", rpm:"asterisk~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ais", rpm:"asterisk-ais~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-alsa", rpm:"asterisk-alsa~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-apidoc", rpm:"asterisk-apidoc~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-curl", rpm:"asterisk-curl~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-dahdi", rpm:"asterisk-dahdi~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-devel", rpm:"asterisk-devel~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-fax", rpm:"asterisk-fax~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-festival", rpm:"asterisk-festival~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ices", rpm:"asterisk-ices~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-jabber", rpm:"asterisk-jabber~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-jack", rpm:"asterisk-jack~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ldap", rpm:"asterisk-ldap~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-ldap-fds", rpm:"asterisk-ldap-fds~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-lua", rpm:"asterisk-lua~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-minivm", rpm:"asterisk-minivm~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-misdn", rpm:"asterisk-misdn~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-odbc", rpm:"asterisk-odbc~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-oss", rpm:"asterisk-oss~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-portaudio", rpm:"asterisk-portaudio~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-postgresql", rpm:"asterisk-postgresql~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-radius", rpm:"asterisk-radius~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-skinny", rpm:"asterisk-skinny~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-snmp", rpm:"asterisk-snmp~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-sqlite", rpm:"asterisk-sqlite~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-tds", rpm:"asterisk-tds~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-unistim", rpm:"asterisk-unistim~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-usbradio", rpm:"asterisk-usbradio~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail", rpm:"asterisk-voicemail~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail-imap", rpm:"asterisk-voicemail-imap~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail-odbc", rpm:"asterisk-voicemail-odbc~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-voicemail-plain", rpm:"asterisk-voicemail-plain~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"asterisk-debuginfo", rpm:"asterisk-debuginfo~1.6.1.11~1.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
