# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1525 (xine-lib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63380);
 script_cve_id("CVE-2008-5240");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1525 (xine-lib)";
 script_name(name);

 desc = "The remote host is missing an update to xine-lib
announced via advisory FEDORA-2009-1525.

This package contains the Xine library.  It can be used to play back
various media, decode multimedia files from local disk drives, and display
multimedia streamed over the Internet. It interprets many of the most
common multimedia formats available - and some uncommon formats, too.

Update Information:

This release contains one new security fix (CVE-2008-5240) and corrections of
previous security fixes.  It also includes fixes for race conditions in
gapless_switch (ref. kde bug #180339)    See also:
http://sourceforge.net/project/shownotes.php?group_id=9655&release_id=660071

ChangeLog:

* Tue Feb 10 2009 Rex Dieter  - 1.1.16.2-1
- xine-lib-1.1.16.2
* Mon Feb  9 2009 Rex Dieter  - 1.1.16.1-4
- gapless-race-fix patch (kdebug#180339)
* Sat Feb  7 2009 Rex Dieter  - 1.1.16.1-3
- safe-audio-pause patch (kdebug#180339)
* Mon Jan 26 2009 Rex Dieter  - 1.1.16.1-2
- Provides: xine-lib(plugin-abi)%{?_isa} = %{abiver}
- touchup Summary/Description
* Fri Jan 23 2009 Rex Dieter  - 1.1.16.1-1
- xine-lib-1.1.16.1
- include avsync patch (#470568)
* Sun Jan 18 2009 Rex Dieter  - 1.1.16-2
- drop deepbind patch (#480504)
- caca support (EPEL)
* Wed Jan  7 2009 Kevin Kofler  - 1.1.16-1.1
- patch for old libcaca in F9-
* Wed Jan  7 2009 Rex Dieter  - 1.1.16-1
- xine-lib-1.1.16, plugin ABI 1.25
- --with-external-libdvdnav, include mpeg demuxers (#213597)
* Fri Dec 12 2008 Rex Dieter  - 1.1.15-4
- rebuild for pkgconfig deps

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xine-lib' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1525

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1525 (xine-lib)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.16.2~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-devel", rpm:"xine-lib-devel~1.1.16.2~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-extras", rpm:"xine-lib-extras~1.1.16.2~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-pulseaudio", rpm:"xine-lib-pulseaudio~1.1.16.2~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-debuginfo", rpm:"xine-lib-debuginfo~1.1.16.2~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
