# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1526 (squid)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63383);
 script_cve_id("CVE-2009-0478");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1526 (squid)";
 script_name(name);

 desc = "The remote host is missing an update to squid
announced via advisory FEDORA-2009-1526.

ChangeLog:

* Thu Feb  5 2009 Jonathan Steffan  - 7:3.0.STABLE13-1
- upgrade to latest upstream
* Thu Jan 29 2009 Henrik Nordstrom  - 7:3.0.STABLE12-1
- upgrade to latest upstream
* Fri Dec 19 2008 Henrik Nordstrom  - 7:3.0.STABLE10-3
- actually include the upstream bugfixes in the build
* Fri Dec 19 2008 Henrik Nordstrom  - 7:3.0.STABLE10-2
- upstream bugfixes for cache corruption and access.log response size errors
References:

[ 1 ] Bug #484246 - CVE-2009-0478 Squid denial of service flaw
https://bugzilla.redhat.com/show_bug.cgi?id=484246

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update squid' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1526

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1526 (squid)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"squid", rpm:"squid~3.0.STABLE13~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~3.0.STABLE13~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
