# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2179 (rubygem-actionpack)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63465);
 script_cve_id("CVE-2008-5189", "CVE-2008-4094");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-2179 (rubygem-actionpack)";
 script_name(name);

 desc = "The remote host is missing an update to rubygem-actionpack
announced via advisory FEDORA-2009-2179.

Update Information:

CVE-2008-5189: CGI header injection vulnerability

ChangeLog:

* Thu Feb 26 2009 Jeroen van Meeuwen  - 2.1.1-2
- Fix CVE-2008-5189
* Tue Sep 16 2008 David Lutterkort  - 2.1.1-1
- New version (fixes CVE-2008-4094)
* Thu Jul 31 2008 Michael Stahnke  - 2.1.0-1
- New Upstream

References:

[ 1 ] Bug #472510 - CVE-2008-5189 rubygems-actionpack: redirect HTTP header injection vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=472510

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update rubygem-actionpack' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2179

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2179 (rubygem-actionpack)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"rubygem-actionpack", rpm:"rubygem-actionpack~2.1.1~2.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
