# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2654 (mod_security)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63590);
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-2654 (mod_security)";
 script_name(name);

 desc = "The remote host is missing an update to mod_security
announced via advisory FEDORA-2009-2654.

Update Information:

Security fixes for potential denials of service when using PDF XSS protection as
well as when parsing multipart requests.
http://sourceforge.net/project/shownotes.php?release_id=667542&group_id=68846

ChangeLog:

* Thu Mar 12 2009 Michael Fleming  2.5.9-1
- Update to upstream release 2.5.9
- Fixes potential DoS' in multipart request and PDF XSS handling

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update mod_security' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2654

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2654 (mod_security)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mod_security", rpm:"mod_security~2.5.9~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mod_security-debuginfo", rpm:"mod_security-debuginfo~2.5.9~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
