# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2823 (php-ZendFramework)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64235);
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-2823 (php-ZendFramework)";
 script_name(name);

 desc = "The remote host is missing an update to php-ZendFramework
announced via advisory FEDORA-2009-2823.

Extending the art & spirit of PHP, Zend Framework is based on simplicity,
object-oriented best practices, corporate friendly licensing, and a rigorously
tested agile codebase. Zend Framework is focused on building more secure,
reliable, and modern Web 2.0 applications & web services, and consuming widely
available APIs from leading vendors like Google, Amazon, Yahoo!, Flickr, as
well as API providers and catalogers like StrikeIron and ProgrammableWeb.

ChangeLog:

* Tue Mar 17 2009 Alexander Kahl  - 1.7.7-2
- bump (cannot remove spurious -1 tag)
* Tue Mar 17 2009 Alexander Kahl  - 1.7.7-1
- update to 1.7.7
- PHPUnit dep now >= 3.3.0
- moved Ldap bindings to extra packages (php-ldap dep)
- excluded db adapters with unresolvable deps
- moved mysqli db adapter files to correct package
- support both old and new font deps using conditional

References:

[ 1 ] Bug #487696 - php-ZendFramework: local file inclusion / directory traversal
https://bugzilla.redhat.com/show_bug.cgi?id=487696

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update php-ZendFramework' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2823

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2823 (php-ZendFramework)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"php-ZendFramework", rpm:"php-ZendFramework~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Auth", rpm:"php-ZendFramework-Auth~Adapter~Ldap", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Cache", rpm:"php-ZendFramework-Cache~Backend~Apc", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Cache", rpm:"php-ZendFramework-Cache~Backend~Memcached", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Captcha", rpm:"php-ZendFramework-Captcha~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Db", rpm:"php-ZendFramework-Db~Adapter~Mysqli", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Dojo", rpm:"php-ZendFramework-Dojo~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Feed", rpm:"php-ZendFramework-Feed~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Gdata", rpm:"php-ZendFramework-Gdata~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Ldap", rpm:"php-ZendFramework-Ldap~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Pdf", rpm:"php-ZendFramework-Pdf~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Search", rpm:"php-ZendFramework-Search~Lucene~1.7.7", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-Services", rpm:"php-ZendFramework-Services~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-demos", rpm:"php-ZendFramework-demos~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-extras", rpm:"php-ZendFramework-extras~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ZendFramework-tests", rpm:"php-ZendFramework-tests~1.7.7~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
