# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2859 (weechat)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63654);
 script_cve_id("CVE-2009-0661");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-2859 (weechat)";
 script_name(name);

 desc = "The remote host is missing an update to weechat
announced via advisory FEDORA-2009-2859.

ChangeLog:

* Thu Mar 19 2009 Paul P. Komkoff Jr  - 0.2.6.1-1
- fix bz#490709
* Wed Feb 25 2009 Fedora Release Engineering  - 0.2.6-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

References:

[ 1 ] Bug #490709 - CVE-2009-0661 WeeChat: DoS (crash) when receiving special characters in IRC messages
https://bugzilla.redhat.com/show_bug.cgi?id=490709

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update weechat' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2859

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2859 (weechat)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"weechat", rpm:"weechat~0.2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"weechat-debuginfo", rpm:"weechat-debuginfo~0.2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
