# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3433 (xine-lib)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63781);
 script_cve_id("CVE-2009-0385", "CVE-2009-1274");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-3433 (xine-lib)";
 script_name(name);

 desc = "The remote host is missing an update to xine-lib
announced via advisory FEDORA-2009-3433.

Update Information:

Maintenance release. Fixes two security problems (CVE-2009-0385, CVE-2009-1274)
and a few miscellaneous bugs.    See the upstream changelog for details:
http://sourceforge.net/project/shownotes.php?group_id=9655&release_id=673233

ChangeLog:

* Fri Apr  3 2009 Rex Dieter  - 1.1.16.3-1
- xine-lib-1.1.16.3, plugin-abi 1.26
* Thu Mar 26 2009 Rex Dieter  - 1.1.16.2-6
- add-mime-for-mod.patch
* Tue Mar 10 2009 Kevin Kofler  - 1.1.16.2-5
- rebuild for new ImageMagick
* Thu Feb 26 2009 Fedora Release Engineering  - 1.1.16.2-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild
* Fri Feb 20 2009 Rex Dieter  - 1.1.16.2-3
- xine-lib-devel muiltilib conflict (#477226)
* Tue Feb 17 2009 Rex Dieter  - 1.1.16.2-2
- xine-lib-safe-audio-pause3 patch (#486255, kdebug#180339)
* Tue Feb 10 2009 Kevin Kofler  - 1.1.16.2-1.1
- also patch the caca version check in configure(.ac)
* Tue Feb 10 2009 Rex Dieter  - 1.1.16.2-1
- xine-lib-1.1.16.2
* Mon Feb  9 2009 Rex Dieter  - 1.1.16.1-4
- gapless-race-fix patch (kdebug#180339)
* Sat Feb  7 2009 Rex Dieter  - 1.1.16.1-3
- safe-audio-pause patch (kdebug#180339)

References:

[ 1 ] Bug #495031 - CVE-2009-1274 xine-lib: Quicktime STTS Atom Integer Overflow (TKADV2009-005)
https://bugzilla.redhat.com/show_bug.cgi?id=495031

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xine-lib' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3433

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3433 (xine-lib)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.16.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-devel", rpm:"xine-lib-devel~1.1.16.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-extras", rpm:"xine-lib-extras~1.1.16.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-pulseaudio", rpm:"xine-lib-pulseaudio~1.1.16.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xine-lib-debuginfo", rpm:"xine-lib-debuginfo~1.1.16.3~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
