# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5865 (gupnp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64229);
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-5865 (gupnp)";
 script_name(name);

 desc = "The remote host is missing an update to gupnp
announced via advisory FEDORA-2009-5865.

New upstream release that fixes a bug where the gupnp stack crashes when passed
empty content.

ChangeLog: http://git.gupnp.org/cgit.cgi?url=gupnp/tree/NEWS&id=ce714a6700ce03953a2886a66ec57db59205f4e6

Bug report: http://bugzilla.openedhand.com/show_bug.cgi?id=1604

Other bugs fixed here.
- bug#1570: gupnp doesn't set the pkgconfig lib dir correctly in 64 bit env.
- bug#1574: Avoid using asserts.
- bug#1592: gupnp_device_info_get_icon_url() does not return the closest match.
- bug#1604: Crash on action without any content.

ChangeLog:

* Wed Jun  3 2009 Peter Robinson  0.12.8-1
- New upstream release

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gupnp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5865

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-5865 (gupnp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gupnp", rpm:"gupnp~0.12.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gupnp-devel", rpm:"gupnp-devel~0.12.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gupnp-debuginfo", rpm:"gupnp-debuginfo~0.12.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gupnp-docs", rpm:"gupnp-docs~0.12.8~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
