# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6883 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64289);
 script_cve_id("CVE-2009-0065", "CVE-2008-5079", "CVE-2009-1385", "CVE-2009-1389");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-6883 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-6883.

Update Information:

Update to linux kernel 2.6.27.25:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.25

ChangeLog:

* Sat Jun 20 2009 Chuck Ebbert   2.6.27.25-170.2.72
- Copy fixes from latest F-9:
kvm-make-efer-reads-safe-when-efer-does-not-exist.patch
linux-2.6-dev-zero-avoid-oom-lockup.patch
linux-2.6-parport-quickfix-the-proc-registration-bug.patch
* Sat Jun 20 2009 Chuck Ebbert   2.6.27.25-170.2.70
- Update r8169 network driver to the version in Fedora 9:
the 2.6.30 version + fixes from 2.6.31
* Sat Jun 20 2009 Chuck Ebbert   2.6.27.25-170.2.69
- Linux 2.6.27.25
- Dropped patches merged upstream in -stable:
linux-2.6-x86-workaround-failures-on-intel-atom.patch
ext4.git*
linux-2.6-ext4*
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.68
- Enable Divas (formerly Eicon) ISDN drivers on x86_64. (#480837)
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-170.2.67
- Enable sfc driver for Solarflare SFC4000 network adapter (#499392)
(disabled on powerpc)

References:

[ 1 ] Bug #502981 - CVE-2009-1385 kernel: e1000_clean_rx_irq() denial of service
https://bugzilla.redhat.com/show_bug.cgi?id=502981
[ 2 ] Bug #504726 - CVE-2009-1389 kernel: r8169: fix crash when large packets are received
https://bugzilla.redhat.com/show_bug.cgi?id=504726

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6883

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6883 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.25~170.2.72.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
