# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7937 (znc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64466);
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-7937 (znc)");

 desc = "The remote host is missing an update to znc
announced via advisory FEDORA-2009-7937.

Update Information:

No CVE yet, one has been requested.    Upgrade to 0.072 of ZNC, fixes security
issue in bug 513152    An users data directory traversal flaw was found in the
way ZNC used to handle file upload requests via Direct Client Connection (DCC)
/dcc SEND messages. A remote IRC user could issue a /dcc SEND message with a
specially-crafted content (file to upload), which once accepted by a local,
unsuspecting ZNC user, would overwrite relevant files in the
users//downloads data directory.

References:

[ 1 ] Bug #513152 - ZNC: Users data directory traversal flaw via Direct Client Connection message
https://bugzilla.redhat.com/show_bug.cgi?id=513152

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update znc' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7937

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-7937 (znc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"znc", rpm:"znc~0.072~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"znc-devel", rpm:"znc-devel~0.072~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"znc-debuginfo", rpm:"znc-debuginfo~0.072~3.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
