# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8132 (OpenEXR)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64543);
 script_cve_id("CVE-2009-1720", "CVE-2009-1721");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8132 (OpenEXR)");

 desc = "The remote host is missing an update to OpenEXR
announced via advisory FEDORA-2009-8132.

OpenEXR is a high dynamic-range (HDR) image file format developed by Industrial
Light & Magic for use in computer imaging applications. This package contains
libraries and sample applications for handling the format.

ChangeLog:

* Wed Jul 29 2009 Rex Dieter  1.6.1-8
- CVE-2009-1720 OpenEXR: Multiple integer overflows (#513995)
- CVE-2009-1721 OpenEXR: Invalid pointer free by image decompression (#514003)
* Fri Jul 24 2009 Fedora Release Engineering  - 1.6.1-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

References:

[ 1 ] Bug #513995 - CVE-2009-1720 OpenEXR: Multiple integer overflows
https://bugzilla.redhat.com/show_bug.cgi?id=513995
[ 2 ] Bug #514003 - CVE-2009-1721 OpenEXR: Invalid pointer free by image decompression
https://bugzilla.redhat.com/show_bug.cgi?id=514003

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update OpenEXR' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8132

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8132 (OpenEXR)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"OpenEXR", rpm:"OpenEXR~1.6.1~8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenEXR-devel", rpm:"OpenEXR-devel~1.6.1~8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenEXR-libs", rpm:"OpenEXR-libs~1.6.1~8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenEXR-debuginfo", rpm:"OpenEXR-debuginfo~1.6.1~8.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
