# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8169 (Django)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64548);
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8169 (Django)");

 desc = "The remote host is missing an update to Django
announced via advisory FEDORA-2009-8169.

Django is a high-level Python Web framework that encourages rapid
development and a clean, pragmatic design. It focuses on automating as
much as possible and adhering to the DRY (Don't Repeat Yourself)
principle.

Update Information:

For: http://www.djangoproject.com/weblog/2009/jul/28/security/
ChangeLog:

* Wed Jul 29 2009 Steve 'Ashcrow' Milner  - 1.0.3-6
- Attempted combined spec for F12/11/10 and EL5
* Wed Jul 29 2009 Steve 'Ashcrow' Milner  - 1.0.3-4
- Older builds must ghost django-admin.py[c,o]
* Wed Jul 29 2009 Steve 'Ashcrow' Milner  - 1.0.3-3
- Bump for tag issue.
* Wed Jul 29 2009 Steve 'Ashcrow' Milner  - 1.0.3-2
- Fix changelog.
* Wed Jul 29 2009 Steve 'Ashcrow' Milner  - 1.0.3-1
- Upgrade for http://www.djangoproject.com/weblog/2009/jul/28/security/

References:

[ 1 ] Bug #514581 - Django security update
https://bugzilla.redhat.com/show_bug.cgi?id=514581

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update Django' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8169

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8169 (Django)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"Django", rpm:"Django~1.0.3~6.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"Django-doc", rpm:"Django-doc~1.0.3~6.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
