# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8340 (firebird)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64742);
 script_cve_id("CVE-2009-2620");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8340 (firebird)");

 desc = "The remote host is missing an update to firebird
announced via advisory FEDORA-2009-8340.

Update Information:

Upgrade from previous package version may be a problem  since previous version
remove /var/run/firebird and it shouldn't

This release fix this problem for future updates
If you are in that case (no longer /var/run/firebird directory
after upgrade), just reinstall firebird-2.1.3.18185.0-2 package
or create /var/run/firebird owned by user firebird

ChangeLog:

References:

[ 1 ] Bug #514463 - CVE-2009-2620 firebird-superserver: NULL ptr dereference (DoS) by handling auxiliary connection(s)
https://bugzilla.redhat.com/show_bug.cgi?id=514463

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update firebird' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8340

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8340 (firebird)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"firebird", rpm:"firebird~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-classic", rpm:"firebird-classic~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-devel", rpm:"firebird-devel~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-doc", rpm:"firebird-doc~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-filesystem", rpm:"firebird-filesystem~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-libfbclient", rpm:"firebird-libfbclient~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-libfbembed", rpm:"firebird-libfbembed~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-superserver", rpm:"firebird-superserver~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firebird-debuginfo", rpm:"firebird-debuginfo~2.1.3.18185.0~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
