# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8344 (dhcp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64735);
 script_cve_id("CVE-2009-0692", "CVE-2009-1892");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8344 (dhcp)");

 desc = "The remote host is missing an update to dhcp
announced via advisory FEDORA-2009-8344.

Update Information:

This update to the dhcp package includes fixes for CVE-2009-0692 and
CVE-2009-1892.  More information on these issues are available here:
http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-0692
http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-1892

Note: CVE-2009-0692 had no security consequences on Fedora, thanks
to the use of FORTIFY_SOURCE

ChangeLog:

* Wed Aug  5 2009 David Cantrell  - 12:4.0.0-37
- Fix for CVE-2009-0692
- Fix for CVE-2009-1892 (#511834)

References:

[ 1 ] Bug #511834 - CVE-2009-1892 dhcp: DoS/abort in some configs with client-identifier and hardware address host specifications
https://bugzilla.redhat.com/show_bug.cgi?id=511834

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update dhcp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8344

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8344 (dhcp)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dhclient", rpm:"dhclient~4.0.0~37.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp", rpm:"dhcp~4.0.0~37.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-devel", rpm:"dhcp-devel~4.0.0~37.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libdhcp4client", rpm:"libdhcp4client~4.0.0~37.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libdhcp4client-devel", rpm:"libdhcp4client-devel~4.0.0~37.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-debuginfo", rpm:"dhcp-debuginfo~4.0.0~37.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
